/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.reward;

import com.google.common.collect.Queues;
import dev.toma.gunsrpg.common.quests.reward.IQuestItemProvider;
import dev.toma.gunsrpg.common.quests.reward.QuestRewardList;
import dev.toma.gunsrpg.util.ModUtils;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public final class QuestReward {
    private final Choice[] choices;

    private QuestReward(Choice[] choices) {
        this.choices = choices;
    }

    public QuestReward(CompoundNBT nbt) {
        ListNBT choices = nbt.func_150295_c("choices", 9);
        this.choices = (Choice[])choices.stream().map(inbt -> {
            ListNBT listNBT = (ListNBT)inbt;
            ItemStack[] items = (ItemStack[])listNBT.stream().map(itemStackNbt -> {
                CompoundNBT compoundNBT = (CompoundNBT)itemStackNbt;
                return ItemStack.func_199557_a((CompoundNBT)compoundNBT);
            }).toArray(ItemStack[]::new);
            return new Choice(items);
        }).toArray(Choice[]::new);
    }

    public Choice[] getChoices() {
        return this.choices;
    }

    public static QuestReward generate(QuestRewardList list, Options options, PlayerEntity player) {
        int totalProviderCount = list.size();
        AbstractCollection generatedCollection = options.unique ? new HashSet() : new ArrayList();
        int requiredCount = Math.min(totalProviderCount, options.choiceCount * options.itemCount);
        for (int attemptIndex = 0; generatedCollection.size() < requiredCount && attemptIndex < totalProviderCount * 2; ++attemptIndex) {
            IQuestItemProvider provider = list.getRandomProvider();
            generatedCollection.add(provider);
        }
        int providerCount = generatedCollection.size();
        int countPerChoice = options.itemCount;
        int remainder = providerCount % countPerChoice;
        int actualPossibleChoiceCount = providerCount / countPerChoice;
        if (remainder > 0) {
            ++actualPossibleChoiceCount;
        }
        ArrayDeque providerPool = Queues.newArrayDeque((Iterable)generatedCollection);
        Choice[] choices = new Choice[actualPossibleChoiceCount];
        for (int i = 0; i < actualPossibleChoiceCount; ++i) {
            Choice choice;
            IQuestItemProvider[] providers = new IQuestItemProvider[Math.min(countPerChoice, providerPool.size())];
            for (int j = 0; j < providers.length; ++j) {
                providers[j] = (IQuestItemProvider)providerPool.poll();
            }
            choices[i] = choice = Choice.generateItems(providers, player);
        }
        return new QuestReward(choices);
    }

    public CompoundNBT toNbt() {
        CompoundNBT nbt = new CompoundNBT();
        ListNBT list = new ListNBT();
        for (Choice choice : this.choices) {
            list.add((Object)choice.toNbt());
        }
        nbt.func_218657_a("choices", (INBT)list);
        return nbt;
    }

    public static class Options {
        private boolean unique;
        private int itemCount = 1;
        private int choiceCount = 1;

        public Options setUnique() {
            this.unique = true;
            return this;
        }

        public Options items(int items) {
            this.itemCount = items;
            return this;
        }

        public Options choiceCount(int choiceCount) {
            this.choiceCount = choiceCount;
            return this;
        }
    }

    public static class Choice {
        private final ItemStack[] items;

        private Choice(ItemStack[] items) {
            this.items = items;
        }

        public static Choice generateItems(IQuestItemProvider[] providers, PlayerEntity player) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (IQuestItemProvider provider : providers) {
                ItemStack[] processedItems = provider.assembleItem(player);
                list.addAll(Arrays.asList(processedItems));
            }
            return new Choice(list.toArray(new ItemStack[0]));
        }

        public ItemStack[] getContents() {
            return this.items;
        }

        public void distributeToInventory(PlayerEntity player) {
            for (ItemStack stack : this.items) {
                ModUtils.addItem(player, stack);
            }
        }

        public ListNBT toNbt() {
            ListNBT list = new ListNBT();
            for (ItemStack stack : this.items) {
                list.add((Object)stack.serializeNBT());
            }
            return list;
        }
    }
}

